# $Id: Replacer.pm 43100 2015-03-23 09:26:05Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/pwdmodifier/libpwdmodifier/lib/UvT/PwdModifier/Replacer.pm $

use strict;
use warnings FATAL => 'all';

package UvT::PwdModifier::Replacable;

use Spiffy -base;

sub new {
	my ($class, $string) = @_;
	my $self = "$string";
	return bless \$self, $class;
}

sub toString {
	my $self = shift;
	return $$self;
}

use overload
	'""' => \&toString,
	'fallback' => 1;

package UvT::PwdModifier::Replacer;

use Carp;
use URI::Escape;
use Encode qw(is_utf8);

use Spiffy -Base;

field 'items' => {};
field '_loop' => {};

our %htmlentities = (
    '"' => '&quot;',
    "'" => '&apos;',
    '<' => '&lt;',
    '>' => '&gt;',
    '&' => '&amp;',
);

sub _htmlentities() {
    my $html = shift;

    $html =~ s/(["'<>&])/$htmlentities{$1}/ge;
    $html =~ s/([^ -~])/'&#'.ord($1).';'/ge;

    return $html;
}

sub _uri_escape() {
	my $str = shift;
	return is_utf8($str) ? uri_escape_utf8($str) : uri_escape($str);
}

sub _subst1 {
	my $key = shift;

	my $items = $self->items;
	die "unknown key '$key'\n"
		unless exists $items->{$key};

	my $val = $items->{$key};
	die "undefined key '$key'\n"
		unless defined $val;

	return $val;
}

sub _substT {
	my $key = shift;
	my $val = $self->_subst1($key);

	die "unescaped expansion of '$key'\n"
		unless UNIVERSAL::isa($val, 'UvT::PwdModifier::Replacable');

	return $val;
}

sub _subst {
	my $key = shift;
	my $val = $self->_substT($key);

	my $loop = $self->_loop;
	die "loop detected for key '$key'\n"
		if exists $loop->{$key};

	undef $loop->{$key};
	my $str = eval { $self->replace($val) };
	delete $loop->{$key};
	die "while replacing key '$key': $@" if $@;
	return $str;
}

sub replace {
	my $str = shift;

	confess "undefined parameter for Replacer::replace"
		unless defined $str;

	# $a    shorthand for ${a}
	# ${a}  replace recursively
	# $(a)  replace once
	# $<a>  replace once and escape entities
	# $[a]  replace once, apply URL-encoding then escape entities

	$str =~ s/\$(?:\$|([a-z_]\w*)|\{([^}]*)\}|\(([^)]*)\)|<([^>]*)>|\[([^]]*)\])/
			defined $1 ? $self->_subst($1) :
			defined $2 ? $self->_subst($2) :
			defined $3 ? $self->_substT($3) :
			defined $4 ? _htmlentities($self->_subst1($4)) :
			defined $5 ? _htmlentities(_uri_escape($self->_subst1($5))) :
			'$'
		/eig;

	return $str;
}
