#!/usr/bin/perl

# $Id: wireless_traphic_sent.pl 7604 2013-04-11 09:31:51Z joostvb $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-cacti-plugins/contrib/wireless_traphic_sent.pl $

use warnings 'all';
use strict;

my %totalTraphicPerControllerSent = ();

&getWLCTraphic("172.20.16.7", "wism-prim1");
&getWLCTraphic("172.20.16.9", "wism-prim2");
&getWLCTraphic("172.20.16.11", "wism-sec1");
&getWLCTraphic("172.20.16.13", "wism-sec2");

sub getWLCTraphic($_)
{
	my $totalSent = 0;

	open(RECEIVED, "snmpwalk -v2c -cdpipvk $_[0] 1.3.6.1.4.1.14179.2.1.6.1.3 |");
	while (<RECEIVED>)
	{
		if (/:\s+(\d+)/) 
		{
                        $totalSent = $totalSent + $1;
                }
	}

	$totalTraphicPerControllerSent{$_[1]} = $totalSent;
}

my $output = "";
foreach my $key (keys %totalTraphicPerControllerSent)
{
	$output = $output . "$key:$totalTraphicPerControllerSent{$key} ";
}
print &trim($output);

# Perl trim function to remove whitespace and carriage return from the start and end of the string
sub trim($)
{
  my $string = shift;
  $string =~ s/^\s+//;
  $string =~ s/\s+$//;
  return $string;
}

