#!/usr/bin/perl

# $Id: wireless_cpu_usage.pl 7604 2013-04-11 09:31:51Z joostvb $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-cacti-plugins/contrib/wireless_cpu_usage.pl $

my %cpuUsagePerController = ();

&getWLCCPUUsage("172.20.16.7");
&getWLCCPUUsage("172.20.16.9");
&getWLCCPUUsage("172.20.16.11");
&getWLCCPUUsage("172.20.16.13");

sub getWLCCPUUsage()
{
	my $controller = shift;
        open(CPU, "snmpwalk -v2c -cdpipvk $controller 1.3.6.1.4.1.14179.1.1.5.1.0 |");
	
	while (<CPU>)
	{
                if (/:\s+(\d+)/)
		{
			$cpuUsagePerController{$controller} = $1;
                }
        }
        close(CPU);
}

my $output = $output;

foreach my $contr (keys %cpuUsagePerController) 
{
	$output = $output . "$contr:$cpuUsagePerController{$contr} ";
}

print &trim($output);

sub trim($)
{
  my $string = shift;
  $string =~ s/^\s+//;
  $string =~ s/\s+$//;
  return $string;
}

