#!/usr/bin/perl

use strict;
use warnings 'all';
use Net::SSH2; 

#if ($#ARGV != 0)
#{
#        print "Usage $0 <ip>\n";
#        print "\t<ip> = ip of switch\n";
#        exit 0;
#}

#my $ip = $ARGV[0];
my $ip = "172.31.12.4";

my $ssh_output = getInfoBySSHCliCommand($ip, "cw2k", "DwvhnwUvTbca6Mfl", "enable\nDwvhnwUvTbca6Mfl\nchangeto context system\nshow cpu usage context all\nquit\n");

my %fwsm_context_cpu_usage = ();

my @lines = split /\n/, $ssh_output;
foreach my $line (@lines)
{
	if ($line =~ m/\s+(\d+\.\d)%\s+(\d+\.\d)%\s+(\d+\.\d)%.\s+(.*)\s+$/)
	{
		#print "match : $line\n";
		my $cpu5min = trim($3);
		my $context = $4;
		#print "cpu usage $context : $cpu5min\n";
		#print ">$1< >$2< >$3< >$4<\n";
		$fwsm_context_cpu_usage{$context} = trim($cpu5min);
	}
}

my $output = "";
for my $context_name ( keys %fwsm_context_cpu_usage )
{
        my $cpu_usage = $fwsm_context_cpu_usage{$context_name};
        $output .= "$context_name:$cpu_usage ";
}

print trim($output);

sub getInfoBySSHCliCommand
{
	my ($ip, $username, $password, $command) = @_;

        local $SIG{ALRM} = sub { die "" };
        alarm 3;

	my $ssh2 = Net::SSH2->new();
	$ssh2->connect($ip) or die "Can't connect to $ip : $!\n";
	$ssh2->auth_password($username, $password) or die "Authentication failed: $!\n";

	my $output = ''; my $buffer;
	my $chan = $ssh2->channel();
	$chan->exec("$command") or die "Couldn't exec '$command': $!\n";
	while ( ! $chan->eof() )
	{
		$chan->read($buffer, 1);
		$output .= $buffer;
	}
	$chan->close();
	$ssh2->disconnect();

	$output =~ s/^.*?Password://s;
	$output =~ s/quit.*?$//s; 

        alarm 0; #cancel the alarm if does not hang

	return $output; 
}

# Perl trim function to remove whitespace and carriage return from the start and end of the string
sub trim
{
  my $string = shift;
  $string =~ s/^\s+//;
  $string =~ s/\s+$//;
  return $string;
}

