# $Id$
# $URL$

use strict;
use warnings FATAL => 'all';

package UvT::NOC::Config::ResourceList;

use UvT::NOC::Config::Resource;
use Data::Dumper;

use Clarity -base;

field resources => {};

sub addResource
{
    my ($self, $resource) = @_;

    return unless defined $resource;

    if($self->hasResource($resource))
	{
        warn("### Warning : Resource '" . $resource->name . "' already exists in ResourceList! Resource not added!");
        return;
    }

	$self->resources->{$resource->name} = $resource;
}

sub removeResource
{
	my ($self, $resource) = @_;

	return unless defined $resource;

	my $name = ref $resource ? $resource->name : $resource;

	delete $self->resources->{$name};
}

sub hasResource
{
	my ($self, $resource) = @_;

	my $resourceName = ref $resource ? $resource->name : $resource;

	return defined $self->getResource($resourceName);
}

sub getResource
{
	my ($self, $name) = @_;

	return unless defined $name;

	return $self->resources->{$name};
}

sub getResources
{
    my ($self) = @_;

	return values %{$self->resources};
}

sub removeAllResources
{
    my ($self) = @_;

    delete $self->{resources};
}

sub size
{
    my ($self) = @_;

    return scalar keys %{$self->resources};
}

sub toString
{
	my($self) = @_;
    my $string = "";

    my @resources = $self->getResources();
    for my $i (0..$#resources)
    {
        $string .= "resource=[" . $resources[$i]->toString() . "]" . ( $i < $#resources ? "\n" : ""); 
    }

    return $string;
}

use overload '""' => \&toString;

1;

