use strict;
use warnings FATAL => 'all';

package UvT::NOC::Net::SNMP;

use UvT::NOC::Util::StringUtil;
use Exporter qw(import);

our @EXPORT = qw(getInfoBySNMPv1 getInfoBySNMPv2 walkInfoBySNMPv2 getMaxWalkIntValueBySNMPv2);
our @EXPORT_OK = @EXPORT;


# Functienaam : getInfoBySNMPv1
#
# Parameters : (4x)
#       1) ip adres van het device om uit te lezen
#       2) snmp community string
#       3) snmp oid
#       4) snmp options 
#
# Omschrijving :
#       Functie om data uit te lezen via snmp

sub getInfoBySNMPv1
{
	my ($ip, $community, $oid, $options) = @_;
	my $snmp_output = "";
	
	my $snmp_command = "snmpget -v1 -c$community $ip $oid $options |";
	open(SNMP, $snmp_command);
	while (<SNMP>)
	{
		$snmp_output .= $_;
	}
	close(SNMP);

	return trim($snmp_output);
}


# Functienaam : getInfoBySNMPv2
#
# Parameters : (4x)
#       1) ip adres van het device om uit te lezen
#       2) snmp community string
#       3) snmp oid
#       4) snmp options 
#
# Omschrijving :
#       Functie om data uit te lezen via snmp

sub getInfoBySNMPv2
{
	my ($ip, $community, $oid, $options) = @_;
	my $snmp_output = "";
	
	my $snmp_command = "snmpget -v2c -c$community $ip $oid $options |";
	open(SNMP, $snmp_command);
	while (<SNMP>)
	{
		$snmp_output .= $_;
	}
	close(SNMP);

	return trim($snmp_output);
}


# Functienaam : walkInfoBySNMPv2
#
# Parameters : (4x)
#       1) ip adres van het device om uit te lezen
#       2) snmp community string
#       3) snmp oid
#       4) snmp options
#
# Omschrijving :
#       Functie om data uit te lezen via snmp

sub walkInfoBySNMPv2
{
        my ($ip, $community, $oid, $options) = @_;
        my $snmp_output = "";

        my $snmp_command = "snmpwalk -v2c -c$community $ip $oid $options |";
        open(SNMP, $snmp_command);
        while (<SNMP>)
        {
                $snmp_output .= $_;
        }
        close(SNMP);

        return trim($snmp_output);
}


# Functienaam : getMaxWalkIntValueBySNMPv2
#
# Parameters : (4x)
#       1) ip adres van het device om uit te lezen
#       2) snmp community string
#       3) snmp oid
#       4) snmp options
#
# Omschrijving :
#       Functie om max int value van een snmpwalk uit te lezen via snmp

sub getMaxWalkIntValueBySNMPv2
{
        my ($ip, $community, $oid, $options) = @_;
        my $snmp_output = "";
        my $maxInt = -999999;

        my $snmp_command = "snmpwalk -v2c -c$community $ip $oid $options |";
        open(SNMP, $snmp_command);
        while (<SNMP>)
        {
                if ($_ =~ /^\d+$/)
                {
                        if ($_ > $maxInt)
                        {
                                $maxInt = $_;
                        }
                }
        }
        close(SNMP);

        if ($maxInt != -999999)
        {
                $snmp_output = $maxInt;
        }

        return trim($snmp_output);
}

