# $Id$
# $URL$

use utf8;
use strict;
use warnings FATAL => 'all';

package NOC::Util::ArrayUtil;

use Exporter qw(import);
use Data::Dumper;

our @EXPORT = qw(uniq remove);
our @EXPORT_OK = @EXPORT;

# remove duplicate array entries
sub uniq
{
    return sort keys %{{ map { $_ => 1 } @_ }};
}

# remove element from referenced array
sub remove
{
	my ($array_ref, $element) = @_;

	my $index = 0;
	while ($index <= @$array_ref - 1)
	{
	    my $el = @$array_ref[$index];

	    if ($el eq $element)
	    {
            splice @$array_ref, $index, 1;
	    }
	    else
	    {
            $index++;
	    }
	}
}

1;
