# $Id$
# $URL$

use strict;
use warnings FATAL => 'all';

package NOC::InfraStructure::Port;

#use InfraStructure::Patch;

use Clarity -base;

field name;
field description;
field ifIndex;
field fwdb;
field patch => undef;

sub new
{
        my($class, $name, $description, $ifIndex, $fwdb, $patch) = @_;

        return super(
                        name => $name,
			description => $description,
			ifIndex => $ifIndex,
			fwdb => $fwdb,
			patch => $patch
        );
}

sub toString
{
        my ($self) = @_;

        my $patch = $self->patch;
        return "name=" . $self->name . ", ifIndex=" . $self->ifIndex . ", fwdb=" . $self->fwdb .  ", patch=" . ($patch ? "[$patch]" : "");
}

use overload '""' => \&toString;

1;
