<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="xml" encoding="UTF-8" doctype-public="-//W3C//DTD XHTML 1.1//EN" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"/> 

	<xsl:param name="script_url"/>

	<xsl:template match="/">
		<xsl:variable name="title">
			<xsl:apply-templates mode="title"/>
		</xsl:variable>
		<html xml:lang="en"><head>
			<base href="{$script_url}/"/>
			<link rel='stylesheet' rev='stylesheet' href='//www.fruit.je/css' type='text/css'/>
			<link rel="alternate" type="application/atom+xml" href="/rss" title="Laatste woorden die aan f00f zijn toegevoegd"/>
			<link rel="search" type="application/opensearchdescription+xml" title="Zoek woorden in f00f" href="https://www.fruit.je/download/f00fje.xml"/>
			<script type="text/javascript" src="//www.fruit.je/lang.js"/>
			<title><xsl:value-of select="string($title)"/> – KUB</title>
		</head><body>
			<div id='content'>
				<h1><xsl:value-of select="$title"/></h1>
				<xsl:apply-templates/>
				<p>
					<a href="javascript:setlang('en')">en</a> /
					<a href="javascript:setlang('nl')">nl</a> /
					<a href="javascript:setlang('ja')">ja</a>
				</p>
			</div>
			<xsl:if test="not(status)">
				<div id='terug' class='terug'><p><a href='.'>Back to the index page</a></p></div>
			</xsl:if>
			<div id='footer'><address><a href='http://validator.w3.org/check/referer'><img class='logo' src='//www.fruit.je/pics/xhtml11' alt='XHTML 1.1 compliant'/></a><a href="mailto:webmaster&#37;40fruit.je">mail de webmeester</a></address></div>
		</body></html>
	</xsl:template>

	<!-- prevent extraneous text from showing up -->
	<xsl:template match="text()|@*"/>
</xsl:stylesheet>
