# $Id: Request.pm 35159 2011-07-04 19:24:05Z wsl $
# $URL: https://svn.uvt.nl/its-id/branches/sources/aselect-perl-2/lib/Aselect/UI/SPNEGO/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::SPNEGO::Request;

use MIME::Base64;

use Aselect::UI::Login::Request -self;

const authorization => sub {
	return shift->http('HTTP_AUTHORIZATION');
};

const negotiate => sub {
	my $auth = shift->authorization;
	return undef unless defined $auth;
	unless($auth =~ s/^Negotiate //) {
		warn "wrong Authorization: header found\n";
		return undef;
	}
	return $auth;
};

const feasible => sub {
	my $self = shift;

	return 1 if $self->authorization;
	return 1 if $self->param('domain');

	my $cookie = $self->new_spnego;

	return 1 if $cookie eq 'ok';
	return 1 if $cookie eq 'enabled';

	if($cookie eq 'auto' and my $re = $self->cfg->spnego_useragent and my $ua = $self->user_agent) {
		return $ua =~ $re;
	}

	return undef;
};

field spnego_uid => sub { shift->login; return };

const login => sub {
	my $self = shift;
	my $cfg = $self->cfg;

	my $negotiate = $self->negotiate or return undef;

	my $uid = eval {
		my $binary = decode_base64($negotiate);

		my $asn1 = $cfg->asn1;
		my $decoded = $asn1->decode($binary)
			or die $asn1->error;

		my $token = $decoded->{negToken}{negTokenInit}{mechToken};

		die "no mechToken found\n"
			unless defined $token;

		$cfg->gssapi->authenticate($token);
	};
	warn $@ if $@;
	return undef unless defined $uid;

	$self->spnego_uid($uid);

	die Aselect::UI::SPNEGO::Account->new(req => $self)->response
		unless $cfg->dir->search($uid)->count == 1;

	$self->startsession($uid);

	return $uid;
};
