# $Id: Logout.pm 35117 2011-06-27 20:15:11Z wsl $
# $URL: https://svn.uvt.nl/its-id/branches/sources/aselect-perl-2/lib/Aselect/UI/Logout.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Logout;

use Aselect::UI::Logout::Request;
use Aselect::UI::Logout::Confirm;
use Aselect::UI::Logout::Success;

use Aselect::Handler -self;

sub handle {
	my $req = new Aselect::UI::Logout::Request(cfg => $self, ctx => shift);
	my $doc = $req->confirmation_needed
		? new Aselect::UI::Logout::Confirm(req => $req)
		: new Aselect::UI::Logout::Success(req => $req);
	return $doc->response;
}
