<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
		xmlns="http://www.w3.org/1999/xhtml"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:import href="common.xsl"/>

	<!-- please enter your password -->
	<xsl:template match="password" mode="title">
		<xsl:text>Password authentication</xsl:text>
	</xsl:template>

	<xsl:template match="password">
		<p>Please enter your username and password to log in.</p>
		<form action="login" method="post">
			<table><tr>
				<td><label for="username">Username:</label></td>
				<td><input id="username" type="text" name="username" value="{username}"/></td>
			</tr><tr>
				<td><label for="password">Password:</label></td>
				<td><input id="password" type="password" name="password"/></td>
			</tr>
			<xsl:if test="login/service or login/rid">
				<tr>
					<td/>
					<td><label><input type="checkbox" name="remember" value="true">
						<xsl:if test="login/remember='true'">
							<xsl:attribute name="checked">checked</xsl:attribute>
						</xsl:if>
					</input> Remember my credentials</label></td>
				</tr>
			</xsl:if>
			<tr>
				<td>
					<xsl:apply-templates select="lt|login/rid|login/service|login/renew|login/warn"/>
				</td>
				<td>
					<button type="submit" name="login" value="true"><strong>Log in</strong></button>
					<button type="submit" name="cancel" value="true">Cancel</button>
				</td>
			</tr></table>
			<xsl:apply-templates select="message"/>
		</form>
	</xsl:template>

	<xsl:template match="lt|rid|service|warn|renew">
		<input type="hidden" name="{name()}" value="{string()}"/>
	</xsl:template>

	<xsl:template match="message[.='credentials']">
		<p><strong>Invalid Credentials</strong></p>
	</xsl:template>

	<xsl:template match="message">
		<p><strong><xsl:value-of select="$message"/></strong></p>
	</xsl:template>
</xsl:stylesheet>
