<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
		xmlns="http://www.w3.org/1999/xhtml"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:import href="common.xsl"/>

	<xsl:template match="error[code='rid']" mode="title">
		<xsl:text>Invalid rid parameter</xsl:text>
	</xsl:template>

	<xsl:template match="error[code='rid']">
		<p>Your login request may have expired. Please return to the application and retry the login.</p>
		<p>If that doesn't help, contact your helpdesk or the maintainer of the application.</p>
	</xsl:template>

	<xsl:template match="error[code='service']" mode="title">
		<xsl:text>Invalid service parameter</xsl:text>
	</xsl:template>

	<xsl:template match="error[code='service']">
		<p>There's a problem with the application you are trying to log in to.</p>
		<p>Please contact your helpdesk or the maintainer of the application.</p>
	</xsl:template>

	<xsl:template match="error[code='backend']" mode="title">
		<xsl:text>Trouble contacting the authentication backend</xsl:text>
	</xsl:template>

	<xsl:template match="error[code='backend']">
		<p>There's a problem with a backend system of the Single Sign On server.</p>
		<p>There is little you can do about this except retry after a few minutes. Please contact your helpdesk if the problem persists.</p>
		<p>Apologies for the inconvenience.</p>
	</xsl:template>

	<xsl:template match="error[code='app_id']" mode="title">
		<xsl:text>Application ID unknown</xsl:text>
	</xsl:template>

	<xsl:template match="error[code='app_id']">
		<p>The application ID ‘<xsl:value-of select="args/app_id"/>’ does not exist.</p>
	</xsl:template>

	<xsl:template match="error[code='internal']" mode="title">
		<xsl:text>A problem occurred inside the Single Sign On server</xsl:text>
	</xsl:template>

	<xsl:template match="error[code='internal']">
		<p>There appears to be a problem inside the Single Sign On server.</p>
		<p>There is little you can do about this except retry after a few minutes. Please contact your helpdesk if the problem persists.</p>
		<p>Apologies for the inconvenience.</p>
	</xsl:template>

	<xsl:template match="error[code='http' and args/number='403']" mode="title">
		<xsl:text>Access denied</xsl:text>
	</xsl:template>

	<xsl:template match="error[code='http' and args/number='403']">
		<p>Access to ‘<xsl:value-of select="args/page"/>’ is currently not allowed.</p>
	</xsl:template>

	<xsl:template match="error[code='http' and args/number='404']" mode="title">
		<xsl:text>Page not found</xsl:text>
	</xsl:template>

	<xsl:template match="error[code='http' and args/number='404']">
		<p>No page is available for ‘<xsl:value-of select="args/page"/>’.</p>
	</xsl:template>

	<xsl:template match="error" mode="title">
		<xsl:text>An error occurred</xsl:text>
	</xsl:template>

	<xsl:template match="error">
		<p>There is little you can do about this except retry after a few minutes. Please contact your helpdesk if the problem persists.</p>
		<p>Apologies for the inconvenience.</p>
	</xsl:template>
</xsl:stylesheet>
