# $Id: Request.pm 34998 2011-06-09 08:37:22Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/WS/ValidateCAS/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::WS::ValidateCAS::Request;

use Aselect::UI::Request -self;

param service => sub { die shift->error("Required request parameter 'service' not supplied") unless defined };
param ticket => sub { die shift->error("Required request parameter 'ticket' not supplied") unless defined };
param pgtUrl => sub { 'FIXME' };
param renew => sub { 'FIXME' };

const uid => sub {
	my $self = shift;
	my $cfg = $self->cfg;
	my $crypto = $self->crypto;

	my $ticket = $self->ticket;
	my $service = $self->service;

	my (undef, undef, $uid) = eval { $crypto->check_cas_token('ST', $service, $ticket, $cfg->credential_timeout) };
	warn "validate: $@" if $@;
	return $uid;
};

sub error {
	my $status = new Xyzzy::Status(400, shift);
	return $status->response;
}
