# $Id: Util.pm 34263 2011-03-18 12:25:00Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Util.pm $

use utf8;
use strict;
use warnings FATAL => 'all';;

package Aselect::Util;

use URI::Escape;
use MIME::Base64;
use Exporter 'import';

our @EXPORT = qw(aselect_split aselect_join aselect_url aselect_valid aselect_encode aselect_decode);

sub uri_unescape_plus {
	my $str = shift;
	$str =~ tr/+/ /;
	return uri_unescape($str);
}

sub aselect_split {
	my @items;
	foreach(split('&', shift)) {
		my ($key, $val) = split(/=/o, $_, 2);
		$val = uri_unescape_plus($val) if defined $val;
		push @items, $key, $val;
	}
	return wantarray ? @items : \@items;
}

sub aselect_join {
	my @items;
	while(@_) {
		my $key = shift;
		my $val = shift;
		die "undefined/missing key" unless defined $key;
		push @items, defined $val ? "$key=".uri_escape($val) : $key;
	}
	return join('&', @items)
}

sub aselect_encode {
	return encode_base64(aselect_join(@_), '')
}

sub aselect_decode {
	return aselect_split(decode_base64($_[0]))
}

sub aselect_valid {
	foreach(@_) {
		return unless defined;
		return if /[^ -~]/;
	}
	return 1
}

sub aselect_url {
	my $url = shift;
	my $sep = index($url, '?') == -1 ? '?' : '&';
	my @ret = ($url);
	my $q = $_[0];
	@_ = %$q if ref $q;
	while(@_) {
		my $key = shift;
		my $val = shift;
		push @ret, $sep, $key, '=', uri_escape($val);
		$sep = '&';
	}
	return join('', @ret)
}

1;
