# $Id: Document.pm 35477 2011-09-01 11:43:51Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Status/Document.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Status::Document;

use Xyzzy::Util qw(iso8601);

use Aselect::UI::Document -self;

sub build {
	my $req = $self->req;
	my $cfg = $self->cfg;

	my $root = $self->construct(status =>
		[nonce => $req->create_nonce],
		[warn => $req->new_warn],
		[spnego => $req->new_spnego],
	);
	$self->setDocumentElement($root);

	if(my $uid = $req->uid) {
		my $exp = $req->new_session->expiration;

		my $session = $self->construct(session =>
			[uid => $uid],
			[organization => $cfg->organization],
			[start => iso8601(localtime($exp))],
			[end => iso8601(localtime($exp + $cfg->session_timeout))],
		);

		$root->appendChild($session);
	}
}
