# $Id: Document.pm 35477 2011-09-01 11:43:51Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Settings/Document.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Settings::Document;

use Xyzzy::Util qw(iso8601);

use Aselect::UI::Document -self;

sub build {
	my $req = $self->req;

	my $root = $self->construct(settings =>
		[nonce => $req->create_nonce],
		[warn => $req->new_warn],
		[spnego => $req->new_spnego],
	);
	$self->setDocumentElement($root);
}

sub response {
	my $res = super;
	my $req = $self->req;

	if((my $warn = $req->new_warn) ne $req->cur_warn) {
		my $cookie = $self->bakecookie(warn => $warn);
		if($warn eq 'true') {
			$cookie->expire('1y');
		} else {
			$cookie->expire(0);
		}
		$res->setcookie($cookie);
	}

	if((my $spnego = $req->new_spnego) ne $req->cur_spnego) {
		my $cookie = $self->bakecookie(spnego => $spnego);
		if($spnego eq 'auto') {
			$cookie->expire(0);
		} else {
			$cookie->expire('1y');
		}
		$res->setcookie($cookie);
	}

	return $res;
}
