# $Id: Document.pm 35117 2011-06-27 20:15:11Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Password/Document.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Password::Document;

use Aselect::UI::Document -self;

sub build {
	my $req = $self->req;

	my $root = $self->construct(password =>
		[lt => $req->create_lt]
	);
	$self->setDocumentElement($root);

	if(my $username = $req->username || $req->uid) {
		$root->appendTextChild(username => $username);
	}

	if(my $message = $req->message) {
		$root->appendTextChild(message => $message);
	}

	if(my $rid = $req->rid) {
		$root->appendTextChild(rid => $rid);
	}

	if(my $service = $req->service) {
		$root->appendTextChild(service => $service);
	}
}

sub response {
	my $res = super;
	$res->addheader('Cache-Control' => 'no-store');
	return $res;
}
