# $Id: Confirm.pm 35174 2011-07-05 13:22:23Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Logout/Confirm.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Logout::Confirm;

use Aselect::UI::Document -self;

sub build {
	my $req = $self->req;

	my $root = $self->construct('confirm-logout' =>
		[nonce => $req->create_nonce],
		[warn => $req->new_warn]
	);
	$self->setDocumentElement($root);

	if(my $url = $req->bare_url) {
		$root->appendTextChild(url => $url);
	}
}
