# $Id: Document.pm 35520 2011-09-06 11:01:36Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Document.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Document;

use Xyzzy::Document::XHTML -self;

sub getStylesheet {
	my $lang = $self->req->lang
		or return super;
	my $file = shift;
	return super("$lang/$file", @_);
}

sub transform {
	return if $self->req->raw;
	return super;
}

sub build {
	$self->hook_next;
	my $name = $self->xml->documentElement->nodeName;
	$name =~ tr|:|/|;
	eval { $self->transform($name) };
	warn $@ if $@;
}

sub bakecookie {
	my $cookie = super;
	if(my $domain = $self->cfg->cookiedomain) {
		$cookie->setparameter(Domain => $domain);
	}
	return $cookie;
}

sub response {
	my $res = super;
	my $req = $self->req;

	my $session = $req->new_session->token;
	my $previous = $req->cur_session;
	unless($previous && $previous->token eq $session) {
		my $cookie = $self->bakecookie(session => $session);
		$cookie->setparameter(HttpOnly => 1);
		$res->setcookie($cookie);
	}

	# DOM/XSL system protects against XSS
	$res->setheader('X-XSS-Protection' => 0);

	$res->mimetype('application/xml')
		if $req->raw;

	return $res;
}
