# $Id: Crypto.pm 34263 2011-03-18 12:25:00Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Crypto.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::Crypto::Config;

use Xyzzy::Crypto -self;

*set_aselectsecret = *Xyzzy::Crypto::Config::set_cryptosecret;

package Aselect::Crypto;

use MIME::Base64;
use Crypt::OpenSSL::RSA;
use Crypt::OpenSSL::X509;

use Xyzzy::Crypto -self;

sub pubkey {
	my $pem = @_ > 1 ? join("\n", @_, '') : $_[0];

	if($pem =~ /BEGIN PUBLIC KEY/) {
		return Crypt::OpenSSL::RSA->new_public_key($pem);
	} else {
		my $cert = Crypt::OpenSSL::X509->new_from_string($pem);
		return Crypt::OpenSSL::RSA->new_public_key($cert->pubkey);
	}
}

sub verify_signature {
	my $pubkey = shift;
	my $signature = decode_base64(shift);

	my $data = join('', grep { defined } @_);

	return $pubkey->verify($data, $signature);
}

sub create_cas_token {
	my ($type, $hidden, @keys) = @_;

	my ($time, $salt, $raw) = $self->create_token_data("$type-$hidden", @keys);

	my $encoded = $type.'-'.encode_base($raw, 63);

	return $time, $salt, $encoded;
}

sub check_cas_token {
	my ($type, $hidden, $token, $expiry) = @_;

	die "Invalid token\n"
		unless defined $token;

	die "Invalid token\n"
		unless $token =~ s/^\Q$type\E-//;

	die "Invalid token\n"
		unless $token =~ /^[a-zA-Z0-9_-]+$/;

	$token = decode_base($token, 63);

	return $self->check_token_data("$type-$hidden", $token, $expiry);
}
