<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
		xmlns="http://www.w3.org/1999/xhtml"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:import href="common.xsl"/>

	<!-- overview of your credentials -->
	<xsl:template match="status" mode="title">
		<xsl:text>Status overview</xsl:text>
	</xsl:template>

	<xsl:template match="status">
		<xsl:choose>
			<xsl:when test="session">
				<xsl:apply-templates select="session/uid"/>
				<xsl:apply-templates select="session/organization"/>
				<xsl:apply-templates select="session/start"/>
				<xsl:apply-templates select="session/end"/>
				<form action="logout" method="post"><p>
					<input type="hidden" name="nonce" value="{nonce}"/>
					<button type="submit"><strong>Log out</strong></button>
				</p></form>
			</xsl:when>
			<xsl:otherwise>
				<p>You are not currently logged in.</p>
				<form action='login' method='get'>
					<p><button type='submit'><strong>Log in</strong></button></p>
				</form>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="uid">
		<p>You are logged in as: <xsl:value-of select="."/>.</p>
	</xsl:template>

	<xsl:template match="organization">
		<p>Your organization is: <xsl:value-of select="."/>.</p>
	</xsl:template>

	<xsl:template match="start">
		<p>Your session started at: <xsl:value-of select="."/>.</p>
	</xsl:template>

	<xsl:template match="end">
		<p>Your session ends at: <xsl:value-of select="."/>.</p>
	</xsl:template>
</xsl:stylesheet>
