<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
		xmlns="http://www.w3.org/1999/xhtml"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:import href="common.xsl"/>

	<!-- overview of your credentials -->
	<xsl:template match="settings" mode="title">
		<xsl:text>Preferences</xsl:text>
	</xsl:template>

	<xsl:template match="settings">
		<xsl:apply-templates select="warn"/>
		<xsl:apply-templates select="spnego"/>
	</xsl:template>

	<xsl:template match="warn[.='true']">
		<p>Warnings are currently enabled. <form action="settings" method="post" style="display: inline">
			<input type="hidden" name="nonce" value="{../nonce}"/>
			<input type="hidden" name="warn" value="false"/>
			<button type="submit">Disable</button>
		</form></p>
	</xsl:template>

	<xsl:template match="warn">
		<p>Warnings are currently disabled. <form action="settings" method="post" style="display: inline">
			<input type="hidden" name="nonce" value="{../nonce}"/>
			<input type="hidden" name="warn" value="true"/>
			<button type="submit">Enable</button>
		</form></p>
	</xsl:template>

	<xsl:template match="spnego[.='ok']">
		<p>Domain logon is currently enabled. <form action="settings" method="post" style="display: inline">
			<input type="hidden" name="nonce" value="{../nonce}"/>
			<button type="submit" name="spnego" value="disabled">Disable</button>
		</form></p>
	</xsl:template>

	<xsl:template match="spnego[.='fail']">
		<p>Domain logon is currently disabled. <form action="settings" method="post" style="display: inline">
			<input type="hidden" name="nonce" value="{../nonce}"/>
			<button type="submit" name="spnego" value="enabled">Enable</button>
		</form></p>
	</xsl:template>

	<xsl:template match="spnego[.='enabled']">
		<p>Domain logon is currently force enabled. <form action="settings" method="post" style="display: inline">
			<input type="hidden" name="nonce" value="{../nonce}"/>
			<button type="submit" name="spnego" value="disabled">Disable</button>
		</form></p>
	</xsl:template>

	<xsl:template match="spnego[.='disabled']">
		<p>Domain logon is currently force disabled. <form action="settings" method="post" style="display: inline">
			<input type="hidden" name="nonce" value="{../nonce}"/>
			<button type="submit" name="spnego" value="enabled">Enable</button>
		</form></p>
	</xsl:template>

	<xsl:template match="spnego">
		<p>Domain logon is currently autodetected. <form action="settings" method="post" style="display: inline">
			<input type="hidden" name="nonce" value="{../nonce}"/>
			<button type="submit" name="spnego" value="disabled">Disable</button>
			<button type="submit" name="spnego" value="enabled">Enable</button>
		</form></p>
	</xsl:template>
</xsl:stylesheet>
