# $Id: facedin.spec 45546 2016-08-26 13:17:55Z joostvb $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/facedin/facedin.spec $

# see also http://git.mdcc.cx/uruk-pkg uruk.spec

%define version 1.12
%define release 1

%define name facedin
%define source_ext gz

Summary:   User management tool
Name:      %{name}
Version:   %{version}
Release:   %{release}

BuildArch: noarch
Source0:   %{name}_%{version}.tar.%{source_ext}

Requires : perl, uruk >= 20150401-1

License:   GPL-3+
Group:     Applications/System
Vendor:    Wessel Dankers
URL:       http://non-gnu.uvt.nl/debian/squeeze/facedin/

BuildRoot: %{_tmppath}/%{name}-%{version}-buildroot
Prefix:    %{_prefix}

%description
 This tool allows you to create and remove users using a declarative
 policy. It has hooks for integration with ssh, uruk and sudo.

%prep
%setup -q

%build
%configure
make

%install
make DESTDIR=%{buildroot} install

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root)
%doc AUTHORS README ChangeLog
%{_mandir}/man1/facedin.1.gz
/usr/bin/facedin

%changelog

* Fri Aug 26 2016 Joost van Baal-Ilić <joostvb@uvt.nl> 1.12-1
- New upstream.

* Wed Jun 22 2016 Joost van Baal-Ilić <joostvb@uvt.nl> 1.11-1
- New upstream.
- We get upstream from http://non-gnu.uvt.nl/debian/squeeze/facedin/
  again; adjust Source0.

* Thu Jul 16 2015 Joost van Baal-Ilić <joostvb@uvt.nl> 1.10-1
- New upstream.
- Depend on a suitable version of uruk.
- Use tar filename as found on https://www.fruit.je/download/facedin/.

* Wed Jun 17 2015 Joost van Baal-Ilić <joostvb@uvt.nl> 1.9-1
- New upstream.

* Mon Jan 26 2015 Wessel Dankers <wsl@uvt.nl> 1.8-1
- Fix /etc/uruk/users syntax for sets.

* Fri Oct 24 2014 Joost van Baal-Ilić <joostvb@uvt.nl> 1.7-1
- New upstream (missed a few of them).
- Upstream changed from .xz to .gz.

* Fri Nov 15 2013 Joost van Baal-Ilić <joostvb@uvt.nl> 1.3-1
- New upstream.
- No longer ships NEWS.

* Tue Feb 26 2013 Joost van Baal-Ilić <joostvb@uvt.nl> 1.1-1
- New upstream.  We now get upstream sources from
  http://non-gnu.uvt.nl/debian/squeeze/facedin/facedin_1.1.tar.xz .
  License clarified.

* Thu Feb 15 2013 Joost van Baal-Ilić <joostvb@uvt.nl> 1.0-1
- Initial release.
