from os import environ

from django import setup
environ.setdefault("DJANGO_SETTINGS_MODULE", "eloquent.settings")
setup()

from elo.models import (Word, Translation, WordDialect)
from elo import logger


class MoveTranslations:
    def __init__(self):
        self.duplicates = 0

    def move_translations(self):

        for counter, word in enumerate(Word.objects.all()):
            t = Translation(word=word, text=word.translated_text, lang=word.target_language)
            t.save()
            if counter % 100 == 0:
                logger.info(f"{counter}, {word}")


    def relink_translations(self):
        for counter, tra in enumerate(Translation.objects.all()):
            collection = Word.objects.filter(source_text=tra.word.source_text,
                                             source_language=2)
            if collection.count() > 1:
                #tra.word = collection.first()
                #tra.save()
                logger.info(f'{tra.word.source_text}, {tra.word.id}')


class MoveDialects:
    def move_dialects(self):
        for counter, word in enumerate(Word.objects.all()):
            wd = WordDialect(word=word, dialect=word.dialect, mp3=word.mp3)
            wd.save()
            if counter % 100 == 0:
                logger.info(f"{counter}: {word}, {wd.dialect}, {wd.mp3}")

    def fix_dialects(self):
        for counter, wd in enumerate(WordDialect.objects.all()):
            wd.word = Word.objects.filter(source_text=wd.word.source_text).first()
            wd.save()
            if counter % 100 == 0:
                logger.info(f"{counter}: {wd}")

    def fix_translations(self):
        for counter, tr in enumerate(Translation.objects.all()):
            tr.word = Word.objects.filter(source_text=tr.word.source_text).first()
            tr.save()
            if counter % 100 == 0:
                logger.info(f"{counter}: {tr}")


if __name__ == '__main__':
    #mt = MoveTranslations()
    #mt.relink_translations()
    md = MoveDialects()
    #md.move_dialects()
    md.fix_translations()

