import json
from logging import getLogger, DEBUG

from django.db import IntegrityError
from django import setup
from os import environ
from pathlib import Path

environ.setdefault("DJANGO_SETTINGS_MODULE", "eloquent.settings")
setup()

from elo.models import Word


class PopWord:
    def __init__(self, p: Path):
        with open(p) as f:
            self.j = json.load(f)
            self.logger = getLogger('eloquent')
            self.logger.setLevel(DEBUG)

    def populate(self):
        for w in self.j:
            if w['ID'] < 533:
                continue
            word = Word()
            word.source_text = w['LANGUAGE_TEXT']
            word.source_language_id = w['LANGUAGE_ID']
            word.dialect_id = w['DIALECT_ID']
            word.translated_text = w['TRANSLATION_TEXT']
            word.target_language_id = w['TRANSLATION_ID']
            word.mp3_number = w['MP3_ID']
            word.mp3 = None
            word.mtdate = w['MTDATE']
            try:
                word.save()
            except (IntegrityError, Exception):
                self.logger.error(f'error by word {word.source_text}')


if __name__ == '__main__':
    p = PopWord(Path('config').parent / 'USER.json')
    p.populate()
