from pathlib import Path

from django import setup
from os import environ

from django.core.files import File

environ.setdefault('DJANGO_SETTINGS_MODULE', 'eloquent.settings')
setup()
from elo.models import (Mp3, Word, )

"""
Retrieve the MP3 files from the database and store them in the mp3 directory.
"""


class DumpMp3:
    """
    automate retrieval of mp3 files from the database.
    after running this, you can drop the mp3 table.
    """
    mp3 = Path('mp3')  # default path

    def __init__(self, filepath=mp3):
        self.queryset = Mp3.objects.all()
        self.words = Word.objects.all()
        self.f = filepath

    def make_mp3(self):
        for mp3 in self.queryset:
            with open(self.f / mp3.name, 'wb') as f:
                f.write(mp3.blob_content)


    def assign_mp3(self):
        """
        actually load the local file to the mp3 argument in Word
        :return:
        """
        for word in self.words:
            mp = self.queryset.get(id=word.mp3_number)
            with open(self.mp3 / mp.name, 'rb') as localfile:
                djangofile = File(localfile)
                word.mp3.save(mp.name, djangofile)
                print(mp.name)



if __name__ == '__main__':
    dm3 = DumpMp3()
    dm3.assign_mp3()
