#! /usr/bin/python3 -B

import os, sys, re

# Use distutils so we don't start downloading random stuff from the internet:
from distutils.core import setup

from setuptools import find_packages

with open('debian/changelog') as changelog:
	name, version = re.compile('(\S+) \(([^\)~\s]+)[\)~]').match(changelog.readline()).group(1, 2)

setup(
	name = name,
	version = version,
	url = 'https://tilburguniversity.edu',
	author = 'Wessel Dankers',
	author_email = 'wsl@uvt.nl',
	maintainer = 'Wessel Dankers',
	maintainer_email = 'wsl@uvt.nl',
	license = 'AGPL',
	packages = find_packages(),
	include_package_data = True,
	install_requires = ['django'],
)
